clear

// pick the folder for data:

cd "D:\Projects\Brookings 2015\Taylor Rules\Data"
//cd "C:\Users\g1tjs01\Documents\brookings\1987 extension\files for final submission"

use meetingData, clear

// pick the directory for output
cd "D:\Projects\Brookings 2015\Taylor Rules\Stata"


// create date variable for x-axis
tostring fomcdate, generate(meetingstring)
gen time = date(meetingstring, "YMD")
format time %tdMon_CCYY
drop meetingstring 
tsset time


// Minutes variables
gen wordunc = 100*(mp_cond_uncertaintyactivity+mp_cond_uncertaintyinflation)
gen wordins = 100*(mp_cond_insuranceactivity+mp_cond_insuranceinflation)
gen ul = uncertlevel
replace ul = . if ul==0
gen il = insurlevel
replace il = . if il==0

sort time
save plotdata, replace

// Use calendar time for figures
//import excel "daily.xlsx", firstrow clear
use daily, clear
merge m:1 time using plotdata, nogenerate
format time %tdMon_YY


// Label variables created in this program
label var time "daily variable, displayed in month year format"
label var wordunc "Sum of inflation and activity uncertainty word count percentages"
label var wordins "Sum of inflation and activity insurance word count percentages"
label var ul "Uncertainty indicator for FOMC minutes"
label var il "Insurance indicator for FOMC minutes"

// Figures
graph set print logo off
graph set eps logo off
set scheme s2color

// Figure 4

twoway (bar wordunc time, sort barwidth(0.1)) (scatter ul time, sort yaxis(2) mcolor(red) msize(small)) if time>=tm(1987m8), /// 
	                 xtitle("FOMC Meeting Month")  ylabel(,nogrid) ylabel(-1(2)1, axis(2) nogrid) ///
						ytitle("Percent of Sentences") ytitle("Indicator", axis(2)) legend(off) ///
							 graphregion(color(white) ) aspect(.5)

// Check directory for figures
//graph export "C:\Users\g1tjs01\Documents\brookings\1987 extension\files for final submission\output\uncertainty_minutes.pdf", replace
graph export "C:\swp55\Docs\Brookings 2015\Figures\uncertainty_minutes.pdf", replace


// Figure 5

twoway (bar wordins time, sort barwidth(0.1)) (scatter il time, sort yaxis(2) mcolor(red) msize(small) ) if time>=tm(1987m8), /// 
	                 xtitle("FOMC Meeting Month")  ylabel(,nogrid) ylabel(-1(2)1, axis(2)) ///
						ytitle("Percent of Sentences") ytitle("Indicator", axis(2)) legend(off) ///
							 graphregion(color(white) ) aspect(.5)
							 
//graph export "C:\Users\g1tjs01\Documents\brookings\1987 extension\files for final submission\output\uncertainty_minutes.pdf", replace
graph export "C:\swp55\Docs\Brookings 2015\Figures\insurance_minutes.pdf", replace

